 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO_ERROS]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO_ERROS]
GO
CREATE PROCEDURE  P_EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO_ERROS
AS
SET NOCOUNT on;
/*
	Esta procedure roda dentro da procedure de pendencia de entrada e saida
*/
CREATE TABLE #RsDupDanfe (CD_CTR INT,
							CD_CTR_TITULO INT,
							NUMERO_DUP_ANT VARCHAR(50),
							NUMERO_DUP_NOVO VARCHAR(50))
INSERT INTO #RsDupDanfe
SELECT
	EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO.CD_CTR,
	EST_NF_ENT_DANFE_PROVISORIO_DUPLICATA.CD_CTR_TITULO,
	EST_NF_ENT_DANFE_PROVISORIO_DUPLICATA.NR_TITULO,
	CONVERT(VARCHAR,NR_NF) + '-' + REPLACE(RIGHT( CONVERT(VARCHAR, DT_EMIS_NF, 103),7)  , '/','')+ '-' +
	CONVERT(VARCHAR, ROW_NUMBER() OVER(partition by NR_NF ORDER BY NR_NF) ) AS CODIGO
FROM
	EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO INNER JOIN EST_NF_ENT_DANFE_PROVISORIO ON
	EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO.CD_CTR 
	INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_DUPLICATA ON
	EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO_DUPLICATA.CD_CTR 
WHERE
	(ERROS_VALIDACAO.value('(list/br.itecbrazil.nfe.entidades.notasfiscais.Erro/erro)[2]','varchar(255)')  LIKE '%IX_PG_CRED_NUMERO_TITULO%')

UPDATE
	EST_NF_ENT_DANFE_PROVISORIO_DUPLICATA
SET 
	EST_NF_ENT_DANFE_PROVISORIO_DUPLICATA.NR_TITULO=D.NUMERO_DUP_NOVO,
	EST_NF_ENT_DANFE_PROVISORIO_DUPLICATA.NR_TITULO_ANT=D.NUMERO_DUP_ANT
FROM
	#RsDupDanfe D INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_DUPLICATA ON
	D.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO_DUPLICATA.CD_CTR AND
	D.CD_CTR_TITULO = EST_NF_ENT_DANFE_PROVISORIO_DUPLICATA.CD_CTR_TITULO

--Deletando erros da duplicata
DELETE
	EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO
FROM
	#RsDupDanfe D INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO ON
	D.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO.CD_CTR 
DROP TABLE #RsDupDanfe

--Deletando erros de deadlocked
DELETE
	EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO
FROM
	 EST_NF_ENT_DANFE_PROVISORIO INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO ON
	EST_NF_ENT_DANFE_PROVISORIO.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO.CD_CTR 
WHERE
	(ERROS_VALIDACAO.value('(list/br.itecbrazil.nfe.entidades.notasfiscais.Erro/erro)[2]','varchar(255)')  LIKE '%was deadlocked on lock resources%' or
	  ERROS_VALIDACAO.value('(list/br.itecbrazil.nfe.entidades.notasfiscais.Erro/erro)[2]','varchar(255)')  LIKE '%Cannot insert duplicate key in object%')